<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Ongkir;
use App\Models\Ongkirmember;
use App\Models\Pembayaran;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AkunController extends Controller
{
    public function index()
    {
        $transaksi = Transaksi::where('member_id', Auth::user()->id)->where('jns_transaksi', 'ON')->where('sts_transaksi', 'N')->latest('id', 'desc')->paginate(3);
        $data = [
            'title' => 'Ramizah Store | Akun Member',
            'page' => 'Akun Member',
            'menuActive' => 'akun',
            'menuOpen' => 'akun',
        ];
        return view('home.akun', compact('data', 'transaksi'));
    }


    public function daftar()
    {
        $data = [
            'title' => 'Ramizah Store | Daftar Member',
            'page' => 'Daftar Member',
            'menuActive' => 'daftar',
            'menuOpen' => 'daftar',
        ];
        return view('home.daftar', compact('data'));
    }



    public function registe_member(Request $request)
    {
        $request->validate(
            [
                'nm_member'         => 'required',
                'hp_member'         => 'required|unique:members,hp_member',
                'username'       => 'required|unique:members,username',
                'password'         => 'required|min:6',

                'jns_kelamin'         => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Username sudah pernah diinputkan, silahkan input username lain!',
                'min' => 'Password minimal 6 digit!',
            ]
        );

        $id = Member::create([
            'kd_member'  => kodemember(),
            'nm_member'  => $request->nm_member,
            'hp_member'  => $request->hp_member,
            'email_member'  => $request->email,
            'kelamin_member'  => $request->jns_kelamin,
            'username'  => $request->username,
            'password'  => bcrypt($request->password),
        ])->id;

        $u = User::latest('id', 'asc')->first();
        $o = Ongkir::latest('id', 'asc')->first();

        Ongkirmember::create([
            'user_id' =>  $u->id,
            'member_id' => $id,
            'ongkir_id' => $o->id,
            'alamat' => $request->alamat,
            'sts_alamat' => 'N',
        ]);

        return response()->json();
    }

    public function pembayaran()
    {
        $transaksi = Transaksi::where('member_id', Auth::user()->id)->where('sts_transaksi', 'T')->where('jns_transaksi', 'ON')->latest('id', 'desc')->paginate(3);
        $data = [
            'title' => 'Ramizah Store | Data Pembayaran',
            'page' => 'Data Pembayaran',
            'menuActive' => 'bayar',
            'menuOpen' => 'bayar',
        ];
        return view('home.akun', compact('data', 'transaksi'));
    }

    public function setting_akun()
    {
        $m = Member::where('id', Auth::user()->id)->first();
        $data = [
            'title' => 'Ramizah Store | Data Akun',
            'page' => 'Data Akun',
            'menuActive' => 'setting',
            'menuOpen' => 'setting',
        ];
        return view('home.akun', compact('data', 'm'));
    }

    public function update_akun(Request $request)
    {
        $member = Member::findOrFail(Auth::user()->id);
        if (!Hash::check($request->password, $member->password)) {
            return redirect('setting-akun')->with(['error' => 'Password yang anda masukan salah!']);
        } else {
            $member->update([
                'nm_member'  => $request->nm_member,
                'hp_member'  => $request->hp_member,
                'email_member'  => $request->email_member,
                'kelamin_member'  => $request->kelamin,
                'username'  => $request->username,
            ]);
            return redirect('setting-akun')->with(['success' => 'Data perubahan berhasil disimpan!']);
        }
    }

    public function setting_password()
    {
        $m = Member::where('id', Auth::user()->id)->first();
        $data = [
            'title' => 'Ramizah Store | Ubah Password',
            'page' => 'Ubah Password',
            'menuActive' => 'password',
            'menuOpen' => 'password',
        ];
        return view('home.akun', compact('data', 'm'));
    }

    public function update_password(Request $request)
    {
        $request->validate(
            [
                'pass_lama'  => 'required',
                'password'         => 'required|min:6|confirmed',
                'password_confirmation'  => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'min' => 'Password minimal 6 digit!',
                'confirmed' => 'Konfirmasi password salah!',
            ]
        );

        $member = Member::findOrFail(Auth::user()->id);
        if (!Hash::check($request->pass_lama, $member->password)) {
            return redirect()->back()->with('errpass', 'Password lama anda salah');
        } else {
            Member::findOrFail(Auth::user()->id)->update([
                'password' => Hash::make($request->password),
            ]);

            return redirect()->back()->with('success', 'Password Updated Successfully');
        }
    }
}
